package ru.yandex.direct.captcha.passport.entity.check.request;

import org.asynchttpclient.Param;

public class CaptchaChecksParameter {
    public static final int LOWER_BOUND = 1;
    public static final int UPPER_BOUND = 9;

    public static Param asRequestParameter(int attemptCount) {
        if (attemptCount < LOWER_BOUND || attemptCount > UPPER_BOUND) {
            throw new IllegalArgumentException(String.format("parameter out of range: got %d, expect [%d-%d]",
                    attemptCount, LOWER_BOUND, UPPER_BOUND));
        }
        return new Param("checks", String.valueOf(attemptCount));
    }
}
