package ru.yandex.direct.captcha.passport.entity.check.request;

import org.asynchttpclient.Param;

public enum CaptchaHttpsMode {
    ON,
    ANY;

    private final Param requestParameter;

    CaptchaHttpsMode() {
        requestParameter = new Param("https", name().toLowerCase());
    }

    public static CaptchaHttpsMode fromString(String modeName) {
        return valueOf(modeName.toUpperCase());
    }

    public Param asRequestParameter() {
        return requestParameter;
    }
}
