package ru.yandex.direct.captcha.passport.entity.check.response;

import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * Следует помнить, что по-умолчанию поля {@link #errorType} и {@link #checkStatus} будут выставлены в
 * {@code null} как в случае отсутствия элемента, так и в случае невозвожности 'маппинга' (т.е. в xml значение есть,
 * но в Enum нет соотв Enum-singleton). Для реализации fail-fast поведения следует использовать связку
 * {@link XmlJavaTypeAdapter} + {@link javax.xml.bind.Unmarshaller#setEventHandler(ValidationEventHandler)}
 */
@XmlType
@XmlRootElement(name = "image_check")
public class CaptchaCheckResponse {
    @XmlAttribute(name = "error")
    private ErrorDescription errorType;
    //еще может быть аттрибут error_desc, но он не описан в документации Паспорта, поэтому не мапится:
    //error_desc="image not allocated, go get image on /image first"

    @XmlValue
    private CheckStatus checkStatus;

    public ErrorDescription getErrorType() {
        return errorType;
    }

    public CheckStatus getCheckStatus() {
        return checkStatus;
    }
}
