package ru.yandex.direct.captcha.passport.entity.generate.response;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlType
@XmlRootElement(name = "number")
public class CaptchaGenerateResponse {
    /**
     * Url картинки для распозавания.
     * <p>
     * Имеет тип String(а не Url), т.к. при captchaType = ANY url не будет содержать протокол:
     * {@code "//s.captcha.yandex.net/image?key=d1b5PL8Ebha0pnqxqZpfrP3vJu9POY5G"}
     */
    @XmlAttribute(name = "url")
    private String url;
    /**
     * Id капчи. Потребуется при проверке результата распознавания.
     */
    @XmlValue
    private String requestId;

    public String getUrl() {
        return url;
    }

    public String getRequestId() {
        return requestId;
    }
}
