package ru.yandex.direct.sender;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Strings.isNullOrEmpty;

public class YandexSenderConfig {
    private final String protocol;
    private final String senderHost;
    private final String accountSlug;
    private final String accountToken;

    public YandexSenderConfig(String protocol, String senderHost, String accountSlug, String accountToken) {
        checkArgument(!isNullOrEmpty(protocol));
        checkArgument(!isNullOrEmpty(senderHost));
        checkArgument(!isNullOrEmpty(accountSlug));
        checkArgument(!isNullOrEmpty(accountToken));
        this.protocol = protocol;
        this.accountSlug = accountSlug;
        this.senderHost = senderHost;
        this.accountToken = accountToken;
    }

    public String getProtocol() {
        return protocol;
    }

    public String getAccountSlug() {
        return accountSlug;
    }

    public String getSenderHost() {
        return senderHost;
    }

    public String getAccountToken() {
        return accountToken;
    }
}
