package ru.yandex.direct.sender;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.function.Function;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;

import ru.yandex.direct.asynchttp.AbstractParsableRequest;

import static io.netty.handler.codec.http.HttpResponseStatus.BAD_REQUEST;
import static io.netty.handler.codec.http.HttpResponseStatus.INTERNAL_SERVER_ERROR;
import static io.netty.handler.codec.http.HttpResponseStatus.NOT_FOUND;
import static io.netty.handler.codec.http.HttpResponseStatus.UNAUTHORIZED;
import static org.asynchttpclient.util.HttpConstants.ResponseStatusCodes.OK_200;

public class YandexSenderResponseParser extends AbstractParsableRequest<YandexSenderResponseEntity> {

    private static final Set<Integer> SUCCESS_RESPONSE_CODES = ImmutableSet.of(OK_200,
            BAD_REQUEST.code(),
            UNAUTHORIZED.code(),
            NOT_FOUND.code(),
            INTERNAL_SERVER_ERROR.code());

    private static final ObjectMapper MAPPER = new ObjectMapper();

    public YandexSenderResponseParser(long id, Request request) {
        super(id, request);
    }

    @Override
    public Function<Response, YandexSenderResponseEntity> getParseFunction() {
        return response -> {
            String responseBody = response.getResponseBody(StandardCharsets.UTF_8);
            try {
                return MAPPER.readValue(responseBody, YandexSenderResponseEntity.class);
            } catch (IOException ex) {
                throw new IllegalArgumentException("can not parse json: " + responseBody, ex);
            }
        };
    }

    public boolean isParsableResponse(Response response) {
        return response.hasResponseStatus() && SUCCESS_RESPONSE_CODES.contains(response.getStatusCode());
    }
}
