package ru.yandex.direct.sender;

import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class YandexSenderTemplateParams {
    /**
     * email адресата
     */
    private final String toEmail;
    /**
     * id шаблона
     */
    private final String campaignSlug;
    /**
     * режим отправки: синхронных или через очередь на стороне рассылятора
     */
    private final Boolean async;
    /**
     * параметры шаблона
     */
    private final Map<String, String> args;

    private YandexSenderTemplateParams(String toEmail, String campaignSlug, Boolean async,
                                       Map<String, String> args) {
        this.toEmail = toEmail;
        this.campaignSlug = campaignSlug;
        this.async = async;
        this.args = args;
    }

    public String getToEmail() {
        return toEmail;
    }

    public Boolean getAsync() {
        return async;
    }

    public Map<String, String> getArgs() {
        return args;
    }

    public String getCampaignSlug() {
        return campaignSlug;
    }

    public static class Builder {
        /**
         * email адресата
         */
        private String toEmail;
        /**
         * id шаблона
         */
        private String campaignSlug;
        /**
         * режим отправки: синхронных или через очередь на стороне рассылятора
         */
        private Boolean async;
        /**
         * параметры шаблона
         */
        private Map<String, String> args;

        public Builder withToEmail(String toEmail) {
            this.toEmail = toEmail;
            return this;
        }

        public Builder withAsync(Boolean async) {
            this.async = async;
            return this;
        }

        public Builder withArgs(Map<String, String> args) {
            this.args = ImmutableMap.copyOf(args);
            return this;
        }

        public Builder withCampaignSlug(String campaignSlug) {
            this.campaignSlug = campaignSlug;
            return this;
        }

        public YandexSenderTemplateParams build() {
            if (toEmail == null) {
                //есть замена - параметр to_yandex_puid, но он пока не поддерживается
                throw new YandexSenderException("toEmail is mandatory");
            }
            if (campaignSlug == null) {
                throw new YandexSenderException("campaign slug is mandatory");
            }
            if (args == null) {
                throw new YandexSenderException("args is mandatory");
            }
            if (args.isEmpty() || !args.containsKey("ClientID")) {
                // если письмо не нужно логировать в CRM, то можно передавать ClientID = null
                throw new YandexSenderException("args must contain ClientID of the client we send email to (for CRM)");
            }
            return new YandexSenderTemplateParams(toEmail, campaignSlug, async, args);
        }
    }
}
