package ru.yandex.direct.yasms;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.http.smart.annotations.Xml;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.HeaderMap;
import ru.yandex.direct.http.smart.http.Query;
import ru.yandex.direct.yasms.model.YaSmsSendSmsResponse;

/**
 * https://doc.yandex-team.ru/Passport/YaSMSDevGuide/concepts/About.html
 */
@ParametersAreNonnullByDefault
public interface YaSmsApi {

    @GET("/sendsms")
    @Xml
    Call<YaSmsSendSmsResponse> sendSms(@Query("uid") Long uid,
                                       @Query("phone_id") Long phoneId,
                                       @Query("text") String text,
                                       @Query("sender") String sender,
                                       @Query("utf8") Integer utf8,
                                       @HeaderMap Map<String, String> headers);
}
