package ru.yandex.direct.yasms;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.asynchttp.Result;
import ru.yandex.direct.http.smart.core.Smart;
import ru.yandex.direct.tvm.TvmIntegration;
import ru.yandex.direct.tvm.TvmService;
import ru.yandex.direct.yasms.model.MessageSent;
import ru.yandex.direct.yasms.model.YaSmsSendSmsResponse;

@ParametersAreNonnullByDefault
public class YaSmsClientImpl {

    private static final Logger logger = LoggerFactory.getLogger(YaSmsClientImpl.class);

    private static final String YA_SMS_SENDER_SERVICE = "direct";
    private static final Integer YA_SMS_UTF8_PARAM_VALUE = 1;

    /**
     * Константы для фейковой отправки смс на тестовых средах.
     */
    private static final long FAKE_RESULT_ID = 1;
    private static final String FAKE_SMS_ID = "1";
    private static final YaSmsSendSmsResponse FAKE_SUCCESS_RESPONSE = new YaSmsSendSmsResponse()
            .withMessageSent(new MessageSent().withId(FAKE_SMS_ID));

    private final YaSmsApi yaSmsApi;

    private final boolean isProd;

    public YaSmsClientImpl(String url,
                           ParallelFetcherFactory fetcherFactory,
                           TvmIntegration tvmIntegration,
                           boolean isProd) {
        this.isProd = isProd;

        yaSmsApi = Smart.builder()
                .withParallelFetcherFactory(fetcherFactory)
                .useTvm(tvmIntegration, TvmService.YA_SMS_PROD)
                .withProfileName("ya_sms_client")
                .withBaseUrl(url)
                .addHeaderConfigurator(headers -> headers.add("Content-type", "application/json"))
                .build()
                .create(YaSmsApi.class);
    }

    /**
     * Конструктор для тестов.
     */
    YaSmsClientImpl(YaSmsApi yaSmsApi, boolean isProd) {
        this.yaSmsApi = yaSmsApi;
        this.isProd = isProd;
    }

    Result<YaSmsSendSmsResponse> sendSms(Long uid, Long phoneId, String smsText, Map<String, String> headers) {
        return isProd ? sendSmsProd(uid, phoneId, smsText, headers) : sendSmsTesting(uid, phoneId, smsText, headers);
    }

    private Result<YaSmsSendSmsResponse> sendSmsProd(Long uid,
                                                     Long phoneId,
                                                     String smsText,
                                                     Map<String, String> headers) {
        logger.info("Sending sms to user: {}, phone id: {}", uid, phoneId);

        return yaSmsApi.sendSms(uid, phoneId, smsText, YA_SMS_SENDER_SERVICE, YA_SMS_UTF8_PARAM_VALUE, headers).execute();
    }

    private Result<YaSmsSendSmsResponse> sendSmsTesting(Long uid,
                                                        Long phoneId,
                                                        String smsText,
                                                        Map<String, String> headers) {
        logger.info("Sending sms to user: {}, phone id: {}, sms text: {}, headers: {}", uid, phoneId, smsText, headers);

        Result<YaSmsSendSmsResponse> fakeResult = new Result<>(FAKE_RESULT_ID);
        fakeResult.setSuccess(FAKE_SUCCESS_RESPONSE);

        return fakeResult;
    }
}
