package ru.yandex.direct.yasms;

import java.util.Map;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.asynchttp.Result;
import ru.yandex.direct.common.util.HttpUtil;
import ru.yandex.direct.yasms.model.YaSmsSendSmsResponse;

import static com.google.common.base.Preconditions.checkState;
import static ru.yandex.direct.common.util.HttpUtil.USER_AGENT_HEADER_NAME;

/**
 * Клиент для отправки СМС с помощью API Паспорта.
 * Нужно использовать эту реализацию в случае синхронной отправки СМС по запросу пользователя (нужно, чтобы был доступен
 * заголовок User-Agent и клиентский IP), во всех остальных случаях использовать {@link YaSmsClientCommon}.
 */
@ParametersAreNonnullByDefault
public class YaSmsClientWeb implements YaSmsClient {

    private static final String CLIENT_IP_HEADER = "Ya-Consumer-Client-Ip";
    private static final String USER_AGENT_HEADER = "Ya-Client-User-Agent";

    private final YaSmsClientImpl yaSmsClientImpl;

    public YaSmsClientWeb(YaSmsClientImpl yaSmsClientImpl) {
        this.yaSmsClientImpl = yaSmsClientImpl;
    }

    @Override
    public Result<YaSmsSendSmsResponse> sendSms(Long uid, Long phoneId, String smsText) {
        return yaSmsClientImpl.sendSms(uid, phoneId, smsText, getHeaders());
    }

    private Map<String, String> getHeaders() {
        var httpRequest = HttpUtil.getRequest();

        Optional<String> userAgentHeaderValue = HttpUtil.getHeaderValue(httpRequest, USER_AGENT_HEADER_NAME);
        checkState(userAgentHeaderValue.isPresent());

        return Map.of(
                CLIENT_IP_HEADER, HttpUtil.getRemoteIp(httpRequest),
                USER_AGENT_HEADER, userAgentHeaderValue.get()
        );
    }
}
