package ru.yandex.direct.yasms.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * https://doc.yandex-team.ru/Passport/YaSMSDevGuide/reference/sendsms.html#response
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class YaSmsSendSmsResponse {

    @JsonProperty("message-sent")
    private MessageSent messageSent;

    @JsonProperty("error")
    private String error;

    @JsonProperty("errorcode")
    private SendSmsErrorCode errorCode;

    public MessageSent getMessageSent() {
        return messageSent;
    }

    public void setMessageSent(MessageSent messageSent) {
        this.messageSent = messageSent;
    }

    public YaSmsSendSmsResponse withMessageSent(MessageSent messageSent) {
        setMessageSent(messageSent);
        return this;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public YaSmsSendSmsResponse withError(String error) {
        setError(error);
        return this;
    }

    public SendSmsErrorCode getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(SendSmsErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public YaSmsSendSmsResponse withErrorCode(SendSmsErrorCode errorCode) {
        setErrorCode(errorCode);
        return this;
    }

    public boolean isSuccessful() {
        return messageSent != null;
    }
}
