package ru.yandex.direct.yav.client

import com.fasterxml.jackson.annotation.JsonValue
import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import java.util.*

abstract class RespBase(
    val status: String,
)

class SecretVersionResp(
    status: String,
    val version: SecretVersion
) : RespBase(status)

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
class SecretVersion(
    val createdAt: Long,
    val createdBy: Long,
    val creatorLogin: String,
    val secretName: String,
    val secretUuid: String,
    val value: List<SecretVersionKeyValue>,
    val version: String
)

data class SecretVersionKeyValue(
    val key: String,
    val value: String,
    val encoding: SecretVersionValueEncoding? = null,
) {
    val decodedValue: String
        get() = when (encoding) {
            SecretVersionValueEncoding.BASE64 -> {
                val base64DecodedBytes = Base64.getDecoder().decode(value)
                String(base64DecodedBytes)
            }
            null -> {
                value
            }
        }
}

enum class SecretVersionValueEncoding(
    @JsonValue private val encoding: String
) {
    BASE64("base64");

    override fun toString() = encoding
}
