package ru.yandex.direct.yav.client

import java.util.concurrent.CompletableFuture

interface YavClient {
    fun getSecretValues(secretUuid: String): Map<String, String>

    /**
     * Специальный метод для асинхронного получения значения секрета
     * используется для обновления значения кэшей
     */
    fun getSecretValuesFuture(secretUuid: String): CompletableFuture<Map<String, String>>
}
