package ru.yandex.direct.ydb;

public class YdbPath {
    private final String path;
    private static final String PARTS_DELIMITER = "/";

    private YdbPath(String path) {
        this.path = path;
    }

    public static YdbPath of(String... parts) {
        var pathString = String.join(PARTS_DELIMITER, parts);
        if (!pathString.startsWith(PARTS_DELIMITER)) {
            pathString = PARTS_DELIMITER + pathString;
        }
        return new YdbPath(pathString);
    }

    public String getPath() {
        return path;
    }
}
