package ru.yandex.direct.ydb.builder;

import com.yandex.ydb.table.query.Params;

public class QueryAndParams {
    public enum Type {
        UNKNOWN, READ, WRITE;
    }

    private final String path;
    private final String query;
    private final Params params;
    private final Type type;

    public QueryAndParams(String path, String query, Params params, Type type) {
        this.path = path;
        this.query = query;
        this.params = params;
        this.type = type;
    }

    public String getPath() {
        return path;
    }

    public String getQuery() {
        return query;
    }

    public Params getParams() {
        return params;
    }

    public Type getType() {
        return type;
    }
}
