package ru.yandex.direct.ydb.builder.expression;

import java.util.ArrayList;
import java.util.List;

import com.yandex.ydb.table.values.Type;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.valuecreator.ValueCreator;

public class AliasedExpression<T> implements NamedExpression<T> {

    private final Expression<T> baseExpression;
    private final String name;
    private final List<YqlWithParams> declareYqlWithParamsList = new ArrayList<>();

    public AliasedExpression(Expression<T> expression, String name) {
        this.baseExpression = expression;
        this.name = name;
        initYqlWithParamsList(expression, name);
    }

    @Override
    public ValueCreator<T> getValueCreator() {
        return baseExpression.getValueCreator();
    }

    @Override
    public Type getType() {
        return baseExpression.getType();
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return baseExpression.getYqlWithParamsList();
    }

    @Override
    public String getName() {
        return name;
    }

    public Expression<T> getBaseExpression() {
        return baseExpression;
    }

    public List<YqlWithParams> getDeclareYqlWithParamsList() {
        return declareYqlWithParamsList;
    }

    private void initYqlWithParamsList(Expression<T> expression, String name) {
        declareYqlWithParamsList.addAll(expression.getYqlWithParamsList());
        declareYqlWithParamsList.add(new YqlWithParams(" AS " + name));
    }
}
