package ru.yandex.direct.ydb.builder.expression;

import java.util.ArrayList;
import java.util.List;

import com.yandex.ydb.table.values.PrimitiveType;
import com.yandex.ydb.table.values.Type;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.valuecreator.PrimitiveValueCreator;
import ru.yandex.direct.ydb.builder.valuecreator.ValueCreator;

import static ru.yandex.direct.ydb.builder.valuecreator.TypeValueMapper.getPrimitiveCreator;

public class ArithmeticExpression<T> implements Expression<T> {

    private static final String MINUS_YQL = " - ";
    private static final String PLUS_YQL = " + ";
    private final Type type;
    private ValueCreator<T> valueFunction;
    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    public ArithmeticExpression(String sign, Expression<?> expression1, Expression<?> expression2,
                                PrimitiveType resultType, PrimitiveValueCreator<T> valueFunction) {
        this.type = resultType;
        this.valueFunction = valueFunction;
        initYqlWithParamsList(sign, expression1, expression2);
    }

    @Override
    public ValueCreator<T> getValueCreator() {
        return valueFunction;
    }

    @Override
    public Type getType() {
        return type;
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }

    public static <T> ArithmeticExpression<T> minus(Expression<?> expression1, Expression<?> expression2,
                                                    PrimitiveType resultType) {
        return new ArithmeticExpression<>(MINUS_YQL, expression1, expression2, resultType,
                getPrimitiveCreator(resultType));
    }

    public static <T> ArithmeticExpression<T> plus(Expression<?> expression1, Expression<?> expression2,
                                                   PrimitiveType resultType) {
        return new ArithmeticExpression<>(PLUS_YQL, expression1, expression2, resultType,
                getPrimitiveCreator(resultType));
    }

    private void initYqlWithParamsList(String sign, Expression<?> expression1,
                                       Expression<?> expression2) {
        yqlWithParamsList.add(new YqlWithParams("("));
        yqlWithParamsList.addAll(expression1.getYqlWithParamsList());
        yqlWithParamsList.add(new YqlWithParams(")"));
        yqlWithParamsList.add(new YqlWithParams(sign));
        yqlWithParamsList.add(new YqlWithParams("("));
        yqlWithParamsList.addAll(expression2.getYqlWithParamsList());
        yqlWithParamsList.add(new YqlWithParams(")"));
    }
}
