package ru.yandex.direct.ydb.builder.expression;

import java.util.ArrayList;
import java.util.List;

import com.yandex.ydb.table.values.Type;

import ru.yandex.direct.ydb.builder.Param;
import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.valuecreator.ValueCreator;

public class ConstantExpression<T> implements Expression<T> {
    private static final String DEFAULT_CONSTANT_PARAM_NAME = "constant_param";
    private Type type;
    private ValueCreator<T> ydbValueCreator;
    private List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    public ConstantExpression(T value, String paramName, Type type, ValueCreator<T> ydbValueCreator) {
        this.type = type;
        this.ydbValueCreator = ydbValueCreator;
        var ydbParamName = "$" + paramName;
        yqlWithParamsList.add(new YqlWithParams(ydbParamName, List.of(new Param(ydbParamName, type,
                ydbValueCreator.toYdb(value)))));

    }

    public ConstantExpression(T value, Type type, ValueCreator<T> ydbValueCreator) {
        this(value, DEFAULT_CONSTANT_PARAM_NAME, type, ydbValueCreator);
    }

    @Override
    public ValueCreator<T> getValueCreator() {
        return ydbValueCreator;
    }

    @Override
    public Type getType() {
        return type;
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }
}
