package ru.yandex.direct.ydb.builder.expression;

import java.time.Instant;
import java.util.List;

import com.yandex.ydb.table.values.PrimitiveValue;
import com.yandex.ydb.table.values.Type;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.valuecreator.ValueCreator;

import static com.yandex.ydb.table.values.PrimitiveType.datetime;

public class CurrentUtcDateTimeExpression implements Expression<Instant> {
    private final List<YqlWithParams> yqlWithParamsList = List.of(new YqlWithParams("CurrentUtcDatetime()"));

    @Override
    public ValueCreator<Instant> getValueCreator() {
        return PrimitiveValue::datetime;
    }

    @Override
    public Type getType() {
        return datetime();
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }

    public static CurrentUtcDateTimeExpression currentUtcDateTime() {
        return new CurrentUtcDateTimeExpression();
    }
}
