package ru.yandex.direct.ydb.builder.expression;

import java.util.ArrayList;
import java.util.List;

import com.yandex.ydb.table.values.PrimitiveType;
import com.yandex.ydb.table.values.PrimitiveValue;
import com.yandex.ydb.table.values.Type;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.valuecreator.ValueCreator;
import ru.yandex.direct.ydb.column.Column;

public class JsonExpression<T> implements Expression<T> {

    private static final String JSON_QUERY = "JSON_QUERY";
    private static final String JSON_VALUE = "JSON_VALUE";
    private final Type type;
    private final ValueCreator<T> valueCreator;
    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    private JsonExpression(String template, String columnName, String jsonPath, Type type,
                           ValueCreator<T> valueCreator) {
        this(template, new YqlWithParams(columnName), jsonPath, type, valueCreator);
    }

    private JsonExpression(String template, YqlWithParams jsonYqlWithParams, String jsonPath, Type type,
                           ValueCreator<T> valueCreator) {
        this.type = type;
        this.valueCreator = valueCreator;
        yqlWithParamsList.add(new YqlWithParams(template + "("));
        yqlWithParamsList.add(jsonYqlWithParams);
        yqlWithParamsList.add(new YqlWithParams(", \""));
        yqlWithParamsList.add(new YqlWithParams(jsonPath));
        yqlWithParamsList.add(new YqlWithParams("\")"));
    }

    private JsonExpression(String template, Type type, ValueCreator<T> valueCreator) {
        this.type = type;
        this.valueCreator = valueCreator;
        yqlWithParamsList.add(new YqlWithParams(template));
    }

    @Override
    public Type getType() {
        return type;
    }

    @Override
    public ValueCreator<T> getValueCreator() {
        return valueCreator;
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }

    public static JsonExpression<String> jsonQuery(String columnName, String jsonPath) {
        return new JsonExpression<String>(JSON_QUERY, columnName, jsonPath, PrimitiveType.utf8(), PrimitiveValue::utf8);
    }

    public static JsonExpression<String> jsonValue(String columnName, String jsonPath) {
        return new JsonExpression<>(JSON_VALUE, columnName, jsonPath, PrimitiveType.utf8(), PrimitiveValue::utf8);
    }

    public static JsonExpression<String> jsonValue(Column column, String jsonPath) {
        return new JsonExpression<>(JSON_VALUE, column.getColumnNameWithTable(), jsonPath, PrimitiveType.utf8(),
                PrimitiveValue::utf8);
    }

}
