package ru.yandex.direct.ydb.builder.expression;

import java.util.Collection;
import java.util.List;

import javax.annotation.Nonnull;

import com.yandex.ydb.table.values.ListType;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.Value;

import ru.yandex.direct.ydb.builder.Param;
import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.valuecreator.ValueCreator;

import static java.util.stream.Collectors.toList;

public class ListExpression<T> implements Expression<T> {
    private final Type type;
    private final ValueCreator<T> ydbValueCreator;
    private final List<YqlWithParams> yqlWithParamsList;

    public ListExpression(@Nonnull Collection<T> values, String paramName, Type type,
                          ValueCreator<T> ydbValueCreator) {
        this.type = type;
        this.ydbValueCreator = ydbValueCreator;
        var ydbParamName = "$" + paramName;
        this.yqlWithParamsList = List.of(new YqlWithParams(ydbParamName, calculateParams(ydbParamName, values, type,
                ydbValueCreator)));
    }

    private List<Param> calculateParams(String ydbParamName, Collection<T> values, Type type,
                                        ValueCreator<T> ydbValueCreator) {
        ListType listType = ListType.of(type);

        List<Value> ydbValues = values.stream().map(ydbValueCreator::toYdb).collect(toList());
        return List.of(new Param(ydbParamName, listType, listType.newValue(ydbValues)));
    }

    @Override
    public Type getType() {
        return type;
    }

    @Override
    public ValueCreator<T> getValueCreator() {
        return ydbValueCreator;
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }
}
