package ru.yandex.direct.ydb.builder.predicate;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;

public class AndPredicate implements Predicate {

    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    public AndPredicate(Predicate predicate1, Predicate predicate2) {
        yqlWithParamsList.add(new YqlWithParams("("));
        yqlWithParamsList.addAll(predicate1.getYqlWithParamsList());
        yqlWithParamsList.add(new YqlWithParams(") AND ("));
        yqlWithParamsList.addAll(predicate2.getYqlWithParamsList());
        yqlWithParamsList.add(new YqlWithParams(")"));
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }
}
