package ru.yandex.direct.ydb.builder.predicate;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.expression.Expression;
import ru.yandex.direct.ydb.builder.expression.ListExpression;

public class ComparablePredicate implements Predicate {
    private static final String EQ_SIGN = " = ";
    private static final String NE_SIGN = " <> ";
    private static final String LESS_THEN_SIGN = " < ";
    private static final String GREATER_THEN_SIGN = " > ";

    private static final String LESS_OR_EQUAL_SIGN = " <= ";
    private static final String GREATER_OR_EQUAL_SIGN = " >= ";
    private static final String IN_SIGN = " IN ";
    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    public <T> ComparablePredicate(String sign, Expression<T> expression1, Expression<T> expression2) {
        this.yqlWithParamsList.addAll(expression1.getYqlWithParamsList());
        this.yqlWithParamsList.add(new YqlWithParams(sign));
        this.yqlWithParamsList.addAll(expression2.getYqlWithParamsList());
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }

    public static <T> ComparablePredicate eq(Expression<T> expression1, Expression<T> expression2) {
        return new ComparablePredicate(EQ_SIGN, expression1, expression2);
    }

    public static <T> ComparablePredicate ne(Expression<T> expression1, Expression<T> expression2) {
        return new ComparablePredicate(NE_SIGN, expression1, expression2);
    }

    public static <T> ComparablePredicate lt(Expression<T> expression1, Expression<T> expression2) {
        return new ComparablePredicate(LESS_THEN_SIGN, expression1, expression2);
    }

    public static <T> ComparablePredicate gt(Expression<T> expression1, Expression<T> expression2) {
        return new ComparablePredicate(GREATER_THEN_SIGN, expression1, expression2);
    }

    public static <T> ComparablePredicate le(Expression<T> expression1, Expression<T> expression2) {
        return new ComparablePredicate(LESS_OR_EQUAL_SIGN, expression1, expression2);
    }

    public static <T> ComparablePredicate ge(Expression<T> expression1, Expression<T> expression2) {
        return new ComparablePredicate(GREATER_OR_EQUAL_SIGN, expression1, expression2);
    }

    public static <T> ComparablePredicate in(Expression<T> expression1, ListExpression<T> expression2) {
        return new ComparablePredicate(IN_SIGN, expression1, expression2);
    }
}
