package ru.yandex.direct.ydb.builder.predicate;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.expression.Expression;

public class IsNotNullPredicate implements Predicate {
    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    public IsNotNullPredicate(Expression expression) {
        yqlWithParamsList.addAll(expression.getYqlWithParamsList());
        yqlWithParamsList.add(new YqlWithParams(" IS NOT NULL"));
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }
}
