package ru.yandex.direct.ydb.builder.predicate;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.expression.Expression;

public class IsNullPredicate implements Predicate {
    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    public IsNullPredicate(Expression expression) {
        this.yqlWithParamsList.addAll(expression.getYqlWithParamsList());
        this.yqlWithParamsList.add(new YqlWithParams(" IS NULL"));
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }
}
