package ru.yandex.direct.ydb.builder.predicate;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.expression.Expression;

public class LikePredicate<T> implements Predicate {
    private static final String LIKE_PREDICATE = " LIKE ";
    private static final String ILIKE_PREDICATE = " ILIKE ";
    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    public LikePredicate(String likePredicate, Expression<T> expression1, Expression<String> expression2) {
        this.yqlWithParamsList.addAll(expression1.getYqlWithParamsList());
        this.yqlWithParamsList.add(new YqlWithParams(likePredicate));
        this.yqlWithParamsList.addAll(expression2.getYqlWithParamsList());
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }

    /**
     * case sensitive
     **/
    public static <T> LikePredicate like(Expression<T> expression1, Expression<String> expression2) {
        return new LikePredicate(LIKE_PREDICATE, expression1, expression2);
    }

    /**
     * case insensitive
     **/
    public static <T> LikePredicate ilike(Expression<T> expression1, Expression<String> expression2) {
        return new LikePredicate(ILIKE_PREDICATE, expression1, expression2);
    }
}
