package ru.yandex.direct.ydb.builder.predicate;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;

public class NotPredicate implements Predicate {
    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    public NotPredicate(Predicate predicate) {
        this.yqlWithParamsList.add(new YqlWithParams("NOT ("));
        this.yqlWithParamsList.addAll(predicate.getYqlWithParamsList());
        this.yqlWithParamsList.add(new YqlWithParams(")"));
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }
}
