package ru.yandex.direct.ydb.builder.predicate;

import java.util.List;

import ru.yandex.direct.ydb.builder.YqlQueryHelper;
import ru.yandex.direct.ydb.builder.YqlWithParams;

public interface Predicate extends YqlQueryHelper {
    default Predicate or(Predicate another) {
        return new OrPredicate(this, another);
    }

    default Predicate and(Predicate another) {
        return new AndPredicate(this, another);
    }

    static Predicate not(Predicate predicate) {
        return new NotPredicate(predicate);
    }

    List<YqlWithParams> getYqlWithParamsList();
}
