package ru.yandex.direct.ydb.builder.querybuilder;

import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.predicate.Predicate;
import ru.yandex.direct.ydb.table.Table;

public class DeleteBuilder extends QueryBuilder {
    private static final String DELETE_TEMPLATE = "DELETE FROM %s\n";
    private final List<YqlWithParams> yqlWithParamsList;

    private DeleteBuilder(Table table) {
        var yql = String.format(DELETE_TEMPLATE, table.getRealName());
        this.yqlWithParamsList = List.of(new YqlWithParams(yql));
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }

    public LimitedWhereBuilder where(Predicate predicate) {
        return new LimitedWhereBuilder(this, predicate);
    }

    public static DeleteBuilder deleteFrom(Table table) {
        return new DeleteBuilder(table);
    }
}
