package ru.yandex.direct.ydb.builder.querybuilder;

import java.util.Arrays;
import java.util.List;

import ru.yandex.direct.ydb.builder.expression.Expression;
import ru.yandex.direct.ydb.builder.predicate.Predicate;

public class ExtendedWhereBuilder extends WhereBuilder implements SubQueryLike, UnionLike {
    ExtendedWhereBuilder(QueryBuilder builder, Predicate predicate) {
        super(builder, predicate);
    }

    public GroupByBuilder groupBy(Expression... expressions) {
        List<Expression> expressionList = Arrays.asList(expressions);
        return new GroupByBuilder(this, expressionList);
    }

    public LimitBuilder limit(long limit) {
        return new LimitBuilder(this, limit);
    }

    public OffsetBuilder offset(long offset) {
        return new OffsetBuilder(this, offset);
    }

    public OrderByBuilder orderBy(OrderByBuilder.OrderType orderType, Expression expression1,
                                  Expression... expressions) {
        return new OrderByBuilder(this, orderType, expression1, expressions);
    }

    public OrderByBuilder orderBy(Expression expression1, Expression... expressions) {
        return orderBy(OrderByBuilder.OrderType.ASC, expression1, expressions);
    }
}
