package ru.yandex.direct.ydb.builder.querybuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.expression.Expression;
import ru.yandex.direct.ydb.builder.predicate.Predicate;
import ru.yandex.direct.ydb.table.TableExpression;

public class FromBuilder extends QueryBuilder implements SubQueryLike, UnionLike {
    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    public FromBuilder(QueryBuilder subBuilder, TableExpression table) {
        this.yqlWithParamsList.addAll(subBuilder.getYqlWithParamsList());
        this.yqlWithParamsList.add(new YqlWithParams("FROM "));
        this.yqlWithParamsList.add(new YqlWithParams(table.getTableDeclare(), table.getParams()));
        this.yqlWithParamsList.add(new YqlWithParams("\n"));

    }

    public FromBuilder(QueryBuilder subBuilder, SubQueryBuilder subQueryBuilder) {
        this.yqlWithParamsList.addAll(subBuilder.getYqlWithParamsList());
        this.yqlWithParamsList.add(new YqlWithParams("FROM "));
        this.yqlWithParamsList.addAll(subQueryBuilder.getYqlWithParamsList());
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }

    public JoinBuilder leftJoin(TableExpression tableExpression, JoinBuilder.JoinStatement joinStatement) {
        return new JoinBuilder(true, this, tableExpression, joinStatement);
    }

    public JoinBuilder join(TableExpression tableExpression, JoinBuilder.JoinStatement joinStatement) {
        return new JoinBuilder(this, tableExpression, joinStatement);
    }

    public JoinBuilder join(SubQueryBuilder subQueryBuilder, JoinBuilder.JoinStatement joinStatement) {
        return new JoinBuilder(this, subQueryBuilder, joinStatement);
    }

    public ExtendedWhereBuilder where(Predicate predicate) {
        return new ExtendedWhereBuilder(this, predicate);
    }

    public GroupByBuilder groupBy(Expression... expressions) {
        List<Expression> expressionList = Arrays.asList(expressions);
        return new GroupByBuilder(this, expressionList);
    }

    public LimitBuilder limit(long limit) {
        return new LimitBuilder(this, limit);
    }

    public OffsetBuilder offset(long offset) {
        return new OffsetBuilder(this, offset);
    }

    public HavingBuilder having(Predicate predicate) {
        return new HavingBuilder(this, predicate);
    }

    public OrderByBuilder orderBy(OrderByBuilder.OrderType orderType, Expression expression1,
                                  Expression... expressions) {
        return new OrderByBuilder(this, orderType, expression1, expressions);
    }

    public OrderByBuilder orderBy(Expression expression1, Expression... expressions) {
        return orderBy(OrderByBuilder.OrderType.ASC, expression1, expressions);
    }
}
