package ru.yandex.direct.ydb.builder.querybuilder;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.expression.Expression;
import ru.yandex.direct.ydb.builder.predicate.Predicate;

public class GroupByBuilder extends QueryBuilder implements SubQueryLike {
    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    protected GroupByBuilder(QueryBuilder subBuilder, List<Expression> groupByExpressions) {
        this.yqlWithParamsList.addAll(subBuilder.getYqlWithParamsList());
        this.yqlWithParamsList.add(new YqlWithParams("GROUP BY "));
        for (int i = 0; i < groupByExpressions.size(); i++) {
            if (i != 0) {
                this.yqlWithParamsList.add(new YqlWithParams(",\n"));
            }
            this.yqlWithParamsList.addAll(groupByExpressions.get(i).getYqlWithParamsList());
        }
        this.yqlWithParamsList.add(new YqlWithParams("\n"));
    }


    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }

    public LimitBuilder limit(long limit) {
        return new LimitBuilder(this, limit);
    }

    public OffsetBuilder offset(long offset) {
        return new OffsetBuilder(this, offset);
    }

    public HavingBuilder having(Predicate predicate) {
        return new HavingBuilder(this, predicate);
    }

    public OrderByBuilder orderBy(OrderByBuilder.OrderType orderType, Expression expression1,
                                  Expression... expressions) {
        return new OrderByBuilder(this, orderType, expression1, expressions);
    }

    public OrderByBuilder orderBy(Expression expression1, Expression... expressions) {
        return orderBy(OrderByBuilder.OrderType.ASC, expression1, expressions);
    }

}
