package ru.yandex.direct.ydb.builder.querybuilder;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.expression.Expression;
import ru.yandex.direct.ydb.builder.predicate.Predicate;

public class HavingBuilder extends QueryBuilder implements SubQueryLike {

    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    protected HavingBuilder(QueryBuilder subBuilder, Predicate havingPredicate) {
        this.yqlWithParamsList.addAll(subBuilder.getYqlWithParamsList());
        this.yqlWithParamsList.add(new YqlWithParams("HAVING "));
        this.yqlWithParamsList.addAll(havingPredicate.getYqlWithParamsList());
        this.yqlWithParamsList.add(new YqlWithParams("\n"));
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }

    public OrderByBuilder orderBy(OrderByBuilder.OrderType orderType, Expression expression1,
                                  Expression... expressions) {
        return new OrderByBuilder(this, orderType, expression1, expressions);
    }

    public OrderByBuilder orderBy(Expression expression1, Expression... expressions) {
        return orderBy(OrderByBuilder.OrderType.ASC, expression1, expressions);
    }
}
