package ru.yandex.direct.ydb.builder.querybuilder;

import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.expression.Expression;
import ru.yandex.direct.ydb.table.Table;

import static ru.yandex.direct.ydb.builder.querybuilder.InsertBuilder.InsertType.INSERT;
import static ru.yandex.direct.ydb.builder.querybuilder.InsertBuilder.InsertType.REPLACE;
import static ru.yandex.direct.ydb.builder.querybuilder.InsertBuilder.InsertType.UPSERT;

public class InsertBuilder extends QueryBuilder {

    private static final String INSERT_TEMPLATE = "%s INTO %s\n";
    private final List<YqlWithParams> yqlWithParamsList;

    InsertBuilder(InsertType insertType, Table table) {
        var yql = String.format(INSERT_TEMPLATE, insertType.getCommand(), table.getRealName());
        this.yqlWithParamsList = List.of(new YqlWithParams(yql));
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }

    public SelectBuilder selectAll() {
        return SelectBuilder.select(this);
    }

    public SelectBuilder select(Expression... expressions) {
        return SelectBuilder.select(this, expressions);
    }

    public SelectBuilder selectDistinct(Expression... expressions) {
        return SelectBuilder.select(this, expressions);
    }

    public static InsertBuilder insertInto(Table table) {
        return new InsertBuilder(INSERT, table);
    }

    public static InsertBuilder upsertInto(Table table) {
        return new InsertBuilder(UPSERT, table);
    }

    public static InsertBuilder replaceInto(Table table) {
        return new InsertBuilder(REPLACE, table);
    }

    enum InsertType {
        INSERT("INSERT"),
        UPSERT("UPSERT"),
        REPLACE("REPLACE");
        private String command;

        InsertType(String command) {
            this.command = command;
        }

        public String getCommand() {
            return command;
        }
    }

}
