package ru.yandex.direct.ydb.builder.querybuilder;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.predicate.Predicate;

public class LimitBuilder extends QueryBuilder implements SubQueryLike {
    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    public LimitBuilder(QueryBuilder subBuilder, long limit) {
        this.yqlWithParamsList.addAll(subBuilder.getYqlWithParamsList());
        this.yqlWithParamsList.add(new YqlWithParams("LIMIT " + limit + "\n"));
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }

    public OffsetBuilder offset(long offset) {
        return new OffsetBuilder(this, offset);
    }

    public HavingBuilder having(Predicate predicate) {
        return new HavingBuilder(this, predicate);
    }
}
