package ru.yandex.direct.ydb.builder.querybuilder;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;

public class OffsetBuilder extends QueryBuilder implements SubQueryLike {
    public static final String OFFSET_TEMPLATE = "OFFSET %d\n";
    public final QueryBuilder subBuilder;
    public final long offset;
    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    public OffsetBuilder(QueryBuilder subBuilder, long offset) {
        this.subBuilder = subBuilder;
        this.offset = offset;
        this.yqlWithParamsList.addAll(subBuilder.getYqlWithParamsList());
        this.yqlWithParamsList.add(new YqlWithParams("OFFSET " + offset + "\n"));
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }
}
