package ru.yandex.direct.ydb.builder.querybuilder;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.expression.AliasedExpression;
import ru.yandex.direct.ydb.builder.expression.Expression;

public class OrderByBuilder extends QueryBuilder implements SubQueryLike {
    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    OrderByBuilder(QueryBuilder subBuilder, OrderType orderType, Expression expression1, Expression... expressions) {
        this.yqlWithParamsList.addAll(subBuilder.getYqlWithParamsList());
        this.yqlWithParamsList.add(new YqlWithParams("ORDER BY "));
        this.yqlWithParamsList.addAll(getExpressionQueryAndParams(expression1));
        var delimiter = new YqlWithParams(",\n");
        for (var expression : expressions) {
            this.yqlWithParamsList.add(delimiter);
            yqlWithParamsList.addAll(getExpressionQueryAndParams(expression));
        }
        this.yqlWithParamsList.add(new YqlWithParams(" " + orderType + "\n"));
    }

    private List<YqlWithParams> getExpressionQueryAndParams(Expression expression) {
        /*
         * Если у выражения есть алиас, надо использовать его в OrderBy
         */
        if (expression instanceof AliasedExpression) {
            var alias = ((AliasedExpression<?>) expression).getName();
            return List.of(new YqlWithParams(alias));
        } else {
            return expression.getYqlWithParamsList();
        }
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }

    public LimitBuilder limit(long limit) {
        return new LimitBuilder(this, limit);
    }

    public OffsetBuilder offset(long offset) {
        return new OffsetBuilder(this, offset);
    }

    public enum OrderType {
        ASC("ASC"),
        DESC("DESC");

        private final String string;

        OrderType(String s) {
            this.string = s;
        }

        @Override
        public String toString() {
            return string;
        }
    }
}
