package ru.yandex.direct.ydb.builder.querybuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.expression.AliasedExpression;
import ru.yandex.direct.ydb.builder.expression.Expression;
import ru.yandex.direct.ydb.builder.predicate.Predicate;
import ru.yandex.direct.ydb.table.TableExpression;

public class SelectBuilder extends QueryBuilder implements SubQueryLike, UnionLike {

    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    private SelectBuilder(QueryBuilder subBuilder, List<? extends Expression> expressions, boolean distinct) {
        if (subBuilder != null) {
            this.yqlWithParamsList.addAll(subBuilder.getYqlWithParamsList());
        }
        if (distinct) {
            this.yqlWithParamsList.add(new YqlWithParams("SELECT DISTINCT "));
        } else {
            this.yqlWithParamsList.add(new YqlWithParams("SELECT "));
        }
        if (expressions.isEmpty()) {
            this.yqlWithParamsList.add(new YqlWithParams("*"));
        } else {
            var delimiter = new YqlWithParams(",\n");
            for (int i = 0; i < expressions.size(); i++) {
                if (i != 0) {
                    this.yqlWithParamsList.add(delimiter);
                }
                this.yqlWithParamsList.addAll(getExpressionYqlWithParamList(expressions.get(i)));
            }
        }
        this.yqlWithParamsList.add(new YqlWithParams("\n"));
    }

    private SelectBuilder(List<? extends Expression> expressions, boolean distinct) {
        this(null, expressions, distinct);
    }

    private SelectBuilder(List<? extends Expression> expressions) {
        this(expressions, false);
    }

    private SelectBuilder(QueryBuilder subBuilder, List<? extends Expression> expressions) {
        this(subBuilder, expressions, false);
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }

    public FromBuilder from(TableExpression table) {
        return new FromBuilder(this, table);
    }


    public FromBuilder from(SubQueryBuilder subQueryBuilder) {
        return new FromBuilder(this, subQueryBuilder);
    }

    public static SelectBuilder select(List<? extends Expression> expressions) {
        return new SelectBuilder(expressions);
    }

    public static SelectBuilder selectDistinct(List<Expression> expressions) {
        return new SelectBuilder(expressions, true);
    }

    public static SelectBuilder select(Expression... expressions) {
        return select(null, expressions);
    }

    public static SelectBuilder select() {
        List<Expression> expressions = List.of();
        return new SelectBuilder(expressions);
    }

    public static SelectBuilder select(QueryBuilder builder, Expression... expressions) {
        List<Expression> expressionList = Arrays.asList(expressions);
        return new SelectBuilder(builder, expressionList);
    }

    public static SelectBuilder selectDistinct(QueryBuilder builder, Expression... expressions) {
        List<Expression> expressionList = Arrays.asList(expressions);
        return new SelectBuilder(builder, expressionList, true);
    }

    public static SelectBuilder selectDistinct(Expression... expressions) {
        return selectDistinct(null, expressions);
    }

    public OrderByBuilder orderBy(OrderByBuilder.OrderType orderType, Expression expression1,
                                  Expression... expressions) {
        return new OrderByBuilder(this, orderType, expression1, expressions);
    }

    public OrderByBuilder orderBy(Expression expression1, Expression... expressions) {
        return orderBy(OrderByBuilder.OrderType.ASC, expression1, expressions);
    }

    public ExtendedWhereBuilder where(Predicate predicate) {
        return new ExtendedWhereBuilder(this, predicate);
    }

    private List<YqlWithParams> getExpressionYqlWithParamList(Expression expression) {
        if (expression instanceof AliasedExpression) {
            return ((AliasedExpression) expression).getDeclareYqlWithParamsList();
        } else {
            return expression.getYqlWithParamsList();
        }
    }
}
