package ru.yandex.direct.ydb.builder.querybuilder;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlQueryHelper;
import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.expression.AliasedExpression;
import ru.yandex.direct.ydb.column.AbstractColumn;
import ru.yandex.direct.ydb.column.SubQueryColumn;

public class SubQueryBuilder implements YqlQueryHelper, UnionLike {
    private final SubQueryLike subQueryLike;
    private final String alias;
    private final List<YqlWithParams> yqlWithParamsList;

    public SubQueryBuilder(SubQueryLike subQueryLike, String alias) {
        this.subQueryLike = subQueryLike;
        this.alias = alias;
        var yqlWithParamListTmp = new ArrayList<YqlWithParams>();
        yqlWithParamListTmp.add(new YqlWithParams("("));
        yqlWithParamListTmp.addAll(subQueryLike.getYqlWithParamsList());
        yqlWithParamListTmp.add(new YqlWithParams(")"));
        if (alias != null) {
            yqlWithParamListTmp.add(new YqlWithParams(" AS " + alias + "\n"));
        }
        this.yqlWithParamsList = yqlWithParamListTmp;

    }

    public SubQueryBuilder(SubQueryLike subQueryLike) {
        this(subQueryLike, null);
    }

    public SubQueryBuilder as(String alias) {
        return new SubQueryBuilder(subQueryLike, alias);
    }

    public <T> AbstractColumn<T> getColumn(AbstractColumn<T> column) {
        return new SubQueryColumn<>(column, alias);
    }

    public <T> AbstractColumn<T> getColumn(AliasedExpression<T> expression) {
        return new SubQueryColumn<>(expression, alias);
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }
}
