package ru.yandex.direct.ydb.builder.querybuilder;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.expression.Expression;

public class UnionBuilder extends QueryBuilder implements SubQueryLike, UnionLike {
    private final List<YqlWithParams> yqlWithParamsList;

    public UnionBuilder(UnionLike firstSubQuery, UnionLike secondSubQuery) {
        yqlWithParamsList = new ArrayList<>();
        yqlWithParamsList.addAll(firstSubQuery.getYqlWithParamsList());
        yqlWithParamsList.add(new YqlWithParams("\nUNION ALL\n"));
        yqlWithParamsList.addAll(secondSubQuery.getYqlWithParamsList());
    }

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }

    public LimitBuilder limit(long limit) {
        return new LimitBuilder(this, limit);
    }

    public OrderByBuilder orderBy(OrderByBuilder.OrderType orderType, Expression expression1,
                                  Expression... expressions) {
        return new OrderByBuilder(this, orderType, expression1, expressions);
    }

    public OrderByBuilder orderBy(Expression expression1, Expression... expressions) {
        return orderBy(OrderByBuilder.OrderType.ASC, expression1, expressions);
    }
}
