package ru.yandex.direct.ydb.builder.querybuilder;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.predicate.Predicate;

public abstract class WhereBuilder extends QueryBuilder implements SubQueryLike {
    private final List<YqlWithParams> yqlWithParamsList = new ArrayList<>();

    WhereBuilder(QueryBuilder builder, Predicate predicate) {
        yqlWithParamsList.addAll(builder.getYqlWithParamsList());
        yqlWithParamsList.add(new YqlWithParams("WHERE "));
        yqlWithParamsList.addAll(predicate.getYqlWithParamsList());
        yqlWithParamsList.add(new YqlWithParams("\n"));
    }


    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }
}
