package ru.yandex.direct.ydb.builder.valuecreator;

import java.util.List;

import com.yandex.ydb.table.values.ListType;
import com.yandex.ydb.table.values.ListValue;
import com.yandex.ydb.table.values.Value;

import static java.util.stream.Collectors.toList;

public class ListValueCreator implements ValueCreator<List<Object>> {
    private final ListType listType;
    private final ValueCreator subCreator;

    public ListValueCreator(ListType t) {
        this.listType = t;
        this.subCreator = TypeValueMapper.getValueCreator(t.getItemType());
    }

    @Override
    public ListValue toYdb(List<Object> objects) {
        List<Value> valuesList = objects.stream().map(o -> subCreator.toYdb(o)).collect(toList());
        return listType.newValue(valuesList);
    }
}
