package ru.yandex.direct.ydb.builder.valuecreator;

import java.util.Objects;

import com.yandex.ydb.table.values.OptionalType;
import com.yandex.ydb.table.values.OptionalValue;

public class OptionalValueCreator implements ValueCreator {

    private final OptionalType optionalType;
    private final ValueCreator subCreator;

    public OptionalValueCreator(OptionalType optionalType) {
        this.optionalType = optionalType;
        this.subCreator = TypeValueMapper.getValueCreator(optionalType.getItemType());
    }

    @Override
    public OptionalValue toYdb(Object o) {
        if (Objects.isNull(o)) {
            return optionalType.emptyValue();
        } else {
            return optionalType.newValue(subCreator.toYdb(o));
        }
    }
}
