package ru.yandex.direct.ydb.builder.valuecreator;

import java.util.function.Function;

import com.yandex.ydb.table.values.Value;

public class PrimitiveValueCreator<T> implements ValueCreator<T> {

    private Function<T, Value> valueCreator;

    PrimitiveValueCreator(Function<T, Value> toYdbMapper) {
        this.valueCreator = toYdbMapper;
    }

    @Override
    public Value toYdb(T o) {
        return valueCreator.apply(o);
    }
}
