package ru.yandex.direct.ydb.client;

import com.yandex.ydb.table.result.ResultSetReader;
import com.yandex.ydb.table.result.ValueReader;

import ru.yandex.direct.ydb.builder.expression.NamedExpression;
import ru.yandex.direct.ydb.column.Column;

public class ResultSetReaderWrapped {
    private final ResultSetReader resultSetReader;

    public ResultSetReaderWrapped(ResultSetReader resultSetReader) {
        this.resultSetReader = resultSetReader;
    }

    public ValueReader getValueReader(Column column) {
        int columnIndex = resultSetReader.getColumnIndex(column.getColumnNameWithTable());
        if (columnIndex == -1) {
            columnIndex = resultSetReader.getColumnIndex(column.getColumnName());
        }
        if (columnIndex == -1) {
            throw new IllegalStateException(String.format("Unknown field %s (short - %s)",
                    column.getColumnNameWithTable(),
                    column.getColumnName()));
        }
        return resultSetReader.getColumn(columnIndex);
    }

    public ValueReader getValueReader(NamedExpression expression) {
        int columnIndex = resultSetReader.getColumnIndex(expression.getName());
        if (columnIndex == -1) {
            throw new IllegalStateException(String.format("Unknown field %s",
                    expression.getName()));
        }
        return resultSetReader.getColumn(columnIndex);
    }

    public ValueReader getColumn(String name) {
        return resultSetReader.getColumn(name);
    }

    public ValueReader getColumn(int index) {
        return resultSetReader.getColumn(index);
    }

    public int getRowCount() {
        return resultSetReader.getRowCount();
    }

    public boolean isEmpty() {
        return resultSetReader.getRowCount() == 0;
    }

    public boolean isTruncated() {
        return resultSetReader.isTruncated();
    }

    public boolean next() {
        return resultSetReader.next();
    }
}
