package ru.yandex.direct.ydb.client;

public class YdbSessionProperties {
    private final int maxQueryRetries;
    private final boolean retryNotFound;

    private YdbSessionProperties(int maxQueryRetries, boolean retryNotFound) {
        this.maxQueryRetries = maxQueryRetries;
        this.retryNotFound = retryNotFound;
    }

    public int getMaxQueryRetries() {
        return maxQueryRetries;
    }

    public boolean isRetryNotFound() {
        return retryNotFound;
    }


    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int maxQueryRetries = 5;
        private boolean retryNotFound = false;

        private Builder() {
        }

        public Builder withMaxQueryRetries(int maxQueryRetries) {
            this.maxQueryRetries = maxQueryRetries;
            return this;
        }

        public Builder withRetryNotFound(boolean retryNotFound) {
            this.retryNotFound = retryNotFound;
            return this;
        }

        public YdbSessionProperties build() {
            return new YdbSessionProperties(maxQueryRetries, retryNotFound);
        }
    }
}
