package ru.yandex.direct.ydb.column;

import java.util.List;

import com.yandex.ydb.table.values.PrimitiveType;
import com.yandex.ydb.table.values.Type;

import ru.yandex.direct.ydb.builder.YqlWithParams;
import ru.yandex.direct.ydb.builder.expression.NamedExpression;
import ru.yandex.direct.ydb.builder.valuecreator.PrimitiveValueCreator;
import ru.yandex.direct.ydb.builder.valuecreator.TypeValueMapper;
import ru.yandex.direct.ydb.builder.valuecreator.ValueCreator;
import ru.yandex.direct.ydb.table.temptable.TempTableDescription;

public abstract class AbstractColumn<T> implements NamedExpression<T> {

    private String name;
    private String nameWithTable;
    private PrimitiveType type;
    private PrimitiveValueCreator<T> primitiveValueCreator;
    private List<YqlWithParams> yqlWithParamsList;

    protected AbstractColumn(String referenceTableName, String name, PrimitiveType type) {
        this.name = name;
        this.nameWithTable = referenceTableName != null ? referenceTableName + "." + name : name;
        this.type = type;
        this.primitiveValueCreator = TypeValueMapper.getPrimitiveCreator(type);
        this.yqlWithParamsList = List.of(new YqlWithParams(nameWithTable));
    }

    protected AbstractColumn(TempTableDescription tempTableDescription, String name, PrimitiveType type) {
        this.name = name;
        this.nameWithTable = tempTableDescription.getReferenceTableName() + "." + name;
        this.type = type;
        this.primitiveValueCreator = TypeValueMapper.getPrimitiveCreator(type);
        this.yqlWithParamsList = List.of(new YqlWithParams(nameWithTable));
    }

    public String getColumnName() {
        return name;
    }

    public String getColumnNameWithTable() {
        return nameWithTable;
    }

    @Override
    public String getName() {
        return name;
    }

    public Type getType() {
        return type;
    }

    @Override
    public ValueCreator<T> getValueCreator() {
        return primitiveValueCreator;
    }

    public abstract boolean isNullable();

    @Override
    public List<YqlWithParams> getYqlWithParamsList() {
        return yqlWithParamsList;
    }
}
