package ru.yandex.direct.ydb.column;

import com.yandex.ydb.table.values.PrimitiveType;

import ru.yandex.direct.ydb.table.TableExpression;


public class Column<T> extends AbstractColumn<T> {
    private boolean isNullable = true;
    private boolean isPk = false;

    public Column(TableExpression table, String name, PrimitiveType type) {
        super(table.getReferenceTableName(), name, type);
    }

    public Column<T> nonNull() {
        this.isNullable = false;
        return this;
    }

    public Column<T> pk() {
        this.isPk = true;
        return this;
    }

    @Override
    public boolean isNullable() {
        return isNullable;
    }

    public boolean isPk() {
        return isPk;
    }


}
