package ru.yandex.direct.ydb.column;

import com.yandex.ydb.table.values.PrimitiveType;

import ru.yandex.direct.ydb.builder.expression.AliasedExpression;

public class SubQueryColumn<T> extends AbstractColumn<T> {

    private final boolean isNullable;

    public SubQueryColumn(AbstractColumn<T> baseColumn, String subQueryAlias) {
        super(subQueryAlias, baseColumn.getName(), (PrimitiveType) baseColumn.getType());
        this.isNullable = baseColumn.isNullable();
    }

    public SubQueryColumn(AliasedExpression<T> expression, String subQueryAlias) {
        super(subQueryAlias, expression.getName(), (PrimitiveType) expression.getType());
        this.isNullable = true;
    }

    @Override
    public boolean isNullable() {
        return isNullable;
    }
}
