package ru.yandex.direct.ydb.column;

import com.yandex.ydb.table.values.PrimitiveType;

import ru.yandex.direct.ydb.table.temptable.TempTableDescription;

public class TempColumn<T> extends AbstractColumn<T> {

    private boolean isNullable;

    private TempColumn(TempTableDescription tempTableDescription, String name, PrimitiveType type,
                       boolean isNullable) {
        super(tempTableDescription, name, type);
        this.isNullable = isNullable;
    }


    @Override
    public boolean isNullable() {
        return isNullable;
    }

    public static <T> TempColumn<T> tempCol(TempTableDescription tempTableDescription,
                                            Column<T> abstractColumn) {
        return new TempColumn<>(tempTableDescription, abstractColumn.getColumnName(),
                (PrimitiveType) abstractColumn.getType(), abstractColumn.isNullable());
    }

    public static <T> TempColumn<T> tempCol(TempTableDescription tempTableDescription,
                                            String name, PrimitiveType primitiveType) {
        return new TempColumn<>(tempTableDescription, name, primitiveType, true);
    }

    public static <T> TempColumn<T> tempCol(TempTableDescription tempTableDescription,
                                            String name, PrimitiveType primitiveType, boolean isNullable) {
        return new TempColumn<>(tempTableDescription, name, primitiveType, isNullable);
    }


}
